////////////////////////////////////////////////////////////////////////////////
// TCimaShareware                                                             //
//                                                                            //
// Purpose:  Lets you know when either a time period has been                 //
//           reached (ie 30 trial), a certain date has been                   //
//           past, or when your application has been run a                    //
//           certain number of times.                                         //
//                                                                            //
// Usage:    Just place CimaShareware1->Execute() in your programs            //
//           main form constructor and select your options in the             //
//           Object Inspector.                                                //
//                                                                            //
//   If the ExpireType you choose uses the registry, it will place it in two  //
//  locations (of your choice), and compare the two as a check to see if the  //
//  registry has been "messed" with.  Try to make the ValueNames discrete     //
//  such as "Left" and "Top", and maybe use two different keys to make it hard /
//  for a 'would be cracker' to crack your shareware.  This check triggers the /
//  OnRegistryManipulated event.                                              //
//                                                                            //
//  If the ExpireType is set to " ltDate" it will check to see if the clock   //
//  on the users computer has been set back.  If so, the OnClockSetBack event //
//  is triggered.                                                             //
//                                                                            //
//  When the ZeroLengthOnRegManipulation property is set to true and ExpireType
//  is set to "ltRunTimes" it will update the registry so that an OnExpired   //
//  event is triggered the next time the program is run.                      //
//                                                                            //
//                                                                            //
// Methods:  InstallDate()          ...  ALL METHODS RETURN STRINGS   ...     //
//           DaysLeft()               You can convert them to Integers        //
//           DaysUsed()               or dates with StrToInt() if you         //
//           RunsUsed()               need to.  Depending on wich of          //
//           RunsLeft()               the three Types (ltDays,ltRunTimes,     //
//           GetExpirationDate()      ltDate) you choose, some Methods will   //
//                                    return "N/A" if they do not apply       //
//                                    to that "Type".                         //
//                                                                            //
//                                                                            //
// Events:  OnExpired                                                         //
//          OnRegistryManipulated                                             //
//          OnClockSetBack                                                    //
//                                                                            //
//  In the //Constants section below....                                      //
// Change the const String DefaultRegistry* expressions to your likeing to    //
// customize the components Default Settings when dropped on a form.          //
// You may also change the return string from "N/A" to something else, such   //
// as "-1", for easy conversion to an integer if you are using the methods in //
// calculations.                                                              //
//                                                                            //
//  Demo:                                                                     //
//     If your copy of this component did not come with a demo project you    //
//     can get one by sending e-mail to cimasoftware@usa.net                  //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// by Jarrid Cima                                                             //
//    cimasoftware@usa.net                                                    //
//    http://www.intrnet.net/~jacima/cbuilder                                 //
//                                                                            //
//  Copyright 1997                                                           //
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//  Don't Forget to include the path where you
// placed these components by going to Options->
// Project...->Directories/Conditionals and adding
// the appropiate path, or the compiler will not
// be able to find the Obj files.
//
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "CSTestMain.h"
//---------------------------------------------------------------------------
#pragma link "TcimaShare"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{CS->Execute();     // Begin Reading and Writing to the Registry
                    // this must be called before any other Methods.
 Label4->Caption = CS->InstallDate(); //  ********************************
 Label5->Caption = CS->DaysUsed();    //    Note that all Methods
 Label6->Caption = CS->DaysLeft();    //  return Strings, for simple
 Label7->Caption = CS->RunsUsed();    //  use in Edit Boxes and Labels
 Label8->Caption = CS->RunsLeft();    //    So you can let your users know
                                      //  how much time they have left, etc.
                                      //  ********************************
Label15->Caption = CS->GetExpirationDate();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Exit_btnClick(TObject *Sender)
{
Application->Terminate();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CSExpired(TObject *Sender)
{Application->MessageBox("Your Shareware has now expired!     Please buy my stuff and so on...", "Message from CimaShareware Component Example Project", MB_OK);
 Application->MessageBox("There is also an event that lets you know when the registry has been 'messed' with.\n\nThis check only guards against the common theif, not the hard core crackers.", "Message from CimaShareware Component Example Project", MB_OK);
 Exit_btnClick(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CSRegistryManipulated(TObject *Sender)
{
 Application->MessageBox("Registry has been 'messed' with.\n\nThis check only guards against the common theif, not the hard core crackers.\n\nIf the ZeroLengthOnRegManipulation property is set to true, the expiration time left is set to zero and, effectively, terminates the shareware time length.\nAlso, the next time the program is run, the OnExpired event will be triggered.", "Message from CimaShareware Component Example Project", MB_OK);
if (CS->ZeroLengthOnRegManipulation)
  Application->Terminate();  //  I don't want the program to run if someone is trying
                             //  to crack it.
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CSClockSetBack(TObject *Sender)
{
Application->MessageBox("The Date and/or time has been altered \
on your computer,\nplease reset clock to correct time and try again.",
          "A good Date-crack event", MB_OK);

Application->Terminate();  //  I don't want the program to run if someone is trying
                           //  to crack it.
}
//---------------------------------------------------------------------------
